int alpha = PREFIX(alpha);
float intensity = float(alpha)/100.0;
#define ChannelBlend_Exclusion(B,L)  ((B + L - ((B * L)*2.0)))

vec3 AdjustforJigsaw_Spring(vec3 rgb) // YELLOW
{
	vec3 outputCol;
	outputCol.x = ChannelBlend_Exclusion(rgb.x,86.0/256.0);
	outputCol.y = ChannelBlend_Exclusion(rgb.y,2.0/256.0);
	outputCol.z = ChannelBlend_Exclusion(rgb.z,2.0/256.0);
	return outputCol;
}
vec3 AdjustforJigsaw_Summer(vec3 rgb) //purple
{
	vec3 outputCol;
	outputCol.x= ChannelBlend_Exclusion(rgb.x, 21.0/256.0);
	outputCol.y = ChannelBlend_Exclusion(rgb.y, 59.0/256.0);
	outputCol.z = ChannelBlend_Exclusion(rgb.z, 7.0/256.0);
	return outputCol;
}

vec3 AdjustforJigsaw_Autumn(vec3 rgb) // BLUE
{
	vec3 outputCol;
	outputCol.x = ChannelBlend_Exclusion(rgb.x, 16.0/256.0);
	outputCol.y = ChannelBlend_Exclusion(rgb.y, 5.0/256.0);
	outputCol.z = ChannelBlend_Exclusion(rgb.z, 99.0/256.0);
	return outputCol;
}
vec3 AdjustforJigsaw_Winter(vec3 rgb) //copper
{
	vec3 outputCol;
	outputCol.x = ChannelBlend_Exclusion(rgb.x, 9.0/256.0);
	outputCol.y = ChannelBlend_Exclusion(rgb.y, 62.0/256.0);
	outputCol.z = ChannelBlend_Exclusion(rgb.z, 103.0/256.0);
	return outputCol;
}

vec4 FUNCNAME(vec2 tc)
 {
    vec4 textureColor = INPUT(tc);
    vec4 fragOutCol;
	vec2 uv = tc;
    vec4 inColor = INPUT( uv );
	vec3 col = vec3(0.0);
	float W = iResolution.x;
	float H = iResolution.y;
	
	float whiteGap = 0.00325;
	float colorGapX = 0.33125;
	float colorGapX2 = 2.0*colorGapX;
	float whiteGapY = whiteGap*W/H;
	float colorGapY = (1.0 - whiteGapY)/2.0;
	
	float thirdPlanarX =  1.0 - 638.0/1920.0;
	float thirdPlanarY =  933.0/1079.0;
	vec3 temp; 
	if( uv.y< colorGapY )
		col.xyz = AdjustforJigsaw_Spring(inColor.xyz); 
	else if( uv.y > colorGapY + whiteGapY)
		col.xyz = AdjustforJigsaw_Autumn(inColor.xyz); 
		else col.xyz = vec3(1.0);
		
	if( uv.y < 0.557 && uv.x < 0.557)
		col.xyz = vec3(1.0);	
	if( uv.y < 0.557 - whiteGapY  && uv.x < 0.557 - whiteGap)
		col.xyz = AdjustforJigsaw_Summer(inColor.xyz); 
	if ( uv.y < 0.557 && uv.x < 0.557 + whiteGap &&  uv.x > 0.557 )
	{
		temp = vec3(-0.6/whiteGap*(uv.x - 0.557 -  whiteGap ) + 0.1);
		col.xyz = ChannelBlend_Exclusion(col.xyz,temp);
		
	}
	if( uv.y > 0.29101 && uv.x >  0.73725)
		col.xyz = vec3(1.0);
	if( uv.y > 0.29101 + whiteGapY && uv.x >  0.73725 + whiteGap)
		col.xyz = AdjustforJigsaw_Winter(inColor.xyz);
	
	if( uv.y > 0.29101 && uv.x <  0.73725 && uv.x >  0.73725 - whiteGap)
	{
		temp = vec3(0.6/whiteGap*(uv.x - 0.73725 + whiteGap) + 0.1);
		col.xyz = ChannelBlend_Exclusion(col.xyz,temp);
	}

	 return vec4(inColor.rgb, inColor.a)*(1.0 - intensity) + vec4(col.rgb, inColor.a)*intensity;
 }
 